#ifndef LLF_ECPKI_defs_H
#define LLF_ECPKI_defs_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "DX_VOS_BaseTypes.h"


#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  18 Sept. 2008
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version LLF_ECPKI_defs.h#1:incl:1
   *  \author R.Levin
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines ******************************/

/* Define the maximal allowed width of the exponentiation sliding window 
in range 1...6 for ECC algorithms. This define is actual for projects on 
soft platform. To minimize code size use the minimum value. To optimize 
the performance choose the maximum value */
#define LLF_ECPKI_EXP_SLIDING_WINDOW_MAX_VALUE  LLF_PKI_EXP_SLIDING_WINDOW_MAX_VALUE


/* size of buffer for Barrett modulus tag NP, used in PKI algorithms */
#define LLF_ECPKI_PKA_BARRETT_MOD_TAG_BUFF_SIZE_IN_WORDS  LLF_PKI_PKA_BARRETT_MOD_TAG_BUFF_SIZE_IN_WORDS   


/************************ Enums ********************************/

/************************ Typedefs  ****************************/

/************************ Structs  *****************************/

/************************ Public Variables *********************/

/************************ Public Functions *********************/


#ifdef __cplusplus
}
#endif

#endif
